%% DICTIONARY LEARNING FOR IMAGE DENOISING
%   This file contains an example of how SMALLbox can be used to test different
%   dictionary learning techniques in Image Denoising problem.
%   It calls generateImageDenoiseProblem that will let you to choose image,
%   add noise and use noisy image to generate training set for dictionary
%   learning.
%   Three dictionary learning techniques were compared:
%   -   KSVD - M. Elad, R. Rubinstein, and M. Zibulevsky, "Efficient
%              Implementation of the K-SVD Algorithm using Batch Orthogonal
%              Matching Pursuit", Technical Report - CS, Technion, April 2008.
%   -   KSVDS - R. Rubinstein, M. Zibulevsky, and M. Elad, "Learning Sparse
%               Dictionaries for Sparse Signal Approximation", Technical
%               Report - CS, Technion, June 2009.
%   -   SPAMS - J. Mairal, F. Bach, J. Ponce and G. Sapiro. Online
%               Dictionary Learning for Sparse Coding. International
%               Conference on Machine Learning,Montreal, Canada, 2009
%
%
% Ivan Damnjanovic 2010
%%

clear;

%   If you want to load the image outside of generateImageDenoiseProblem
%   function uncomment following lines. This can be useful if you want to
%   denoise more then one image for example.

% TMPpath=pwd;
% FS=filesep;
% [pathstr1, name, ext, versn] = fileparts(which('SMALLboxSetup.m'));
% cd([pathstr1,FS,'data',FS,'images']);
% [filename,pathname] = uigetfile({'*.png;'},'Select a file containin pre-calculated notes');
% [pathstr, name, ext, versn] = fileparts(filename);
% test_image = imread(filename);
% test_image = double(test_image);
% cd(TMPpath);
% SMALL.Problem.name=name;


% Defining Image Denoising Problem as Dictionary Learning
% Problem. As an input we set the number of training patches.

SMALL.Problem = generateImageDenoiseProblem('', 40000, '','', 20);

Edata=sqrt(prod(SMALL.Problem.blocksize)) * SMALL.Problem.sigma * SMALL.Problem.gain;
maxatoms = floor(prod(SMALL.Problem.blocksize)/2);
%%   Use KSVD Dictionary Learning Algorithm to Learn overcomplete dictionary
% 
% %   Initialising Dictionary structure
% %   Setting Dictionary structure fields (toolbox, name, param, D and time)
% %   to zero values
% 
% SMALL.DL(1)=SMALL_init_DL();
% 
% % Defining the parameters needed for dictionary learning
% 
% SMALL.DL(1).toolbox = 'KSVD';
% SMALL.DL(1).name = 'ksvd';
% 
% %   Defining the parameters for KSVD
% %   In this example we are learning 256 atoms in 20 iterations, so that
% %   every patch in the training set can be represented with target error in
% %   L2-norm (EData)
% %   Type help ksvd in MATLAB prompt for more options.
% 
% 
% SMALL.DL(1).param=struct(...
%     'Edata', Edata,...
%     'initdict', SMALL.Problem.initdict,...
%     'dictsize', SMALL.Problem.p,...
%     'iternum', 20,...
%     'memusage', 'high');
% 
% %   Learn the dictionary
% 
% SMALL.DL(1) = SMALL_learn(SMALL.Problem, SMALL.DL(1));
%%   Initialising Dictionary structure
%   Setting Dictionary structure fields (toolbox, name, param, D and time)
%   to zero values 
% 

SMALL.DL(1)=SMALL_init_DL();
%   Take initial dictonary (overcomplete DCT) to be a final dictionary for
%   reconstruction

SMALL.DL(1).D=SMALL.Problem.initdict;
%%

%   Set SMALL.Problem.A dictionary
%   (backward compatiblity with SPARCO: solver structure communicate
%   only with Problem structure, ie no direct communication between DL and
%   solver structures)
SMALL.Problem.A = SMALL.DL(1).D;

SparseDict=0;
SMALL.Problem.reconstruct = @(x) ImgDenoise_reconstruct(x, SMALL.Problem, SparseDict);

%%
%   Initialising solver structure
%   Setting solver structure fields (toolbox, name, param, solution,
%   reconstructed and time) to zero values


SMALL.solver(1)=SMALL_init_solver;

% Defining the parameters needed for image denoising

SMALL.solver(1).toolbox='ompbox';
SMALL.solver(1).name='omp2';
SMALL.solver(1).param=struct(...
    'epsilon',Edata,...
    'maxatoms', maxatoms); 

%   Denoising the image - SMALL_denoise function is similar to SMALL_solve,
%   but backward compatible with KSVD definition of denoising
%   Pay attention that since implicit base dictionary is used, denoising
%   can be much faster then using explicit dictionary in KSVD example.

SMALL.solver(1)=SMALL_solve(SMALL.Problem, SMALL.solver(1));

%%
%   Initialising solver structure
%   Setting solver structure fields (toolbox, name, param, solution,
%   reconstructed and time) to zero values
lam=2*SMALL.Problem.sigma;%*sqrt(2*log2(size(SMALL.Problem.A,1)))
for i=1:11
    lambda(i)=lam+5-(i-1);
SMALL.DL(2)=SMALL_init_DL();
i
%SMALL.Problem.A = SMALL.Problem.initdict;
SMALL.DL(2).D=SMALL.Problem.initdict;
SMALL.solver(2)=SMALL_init_solver;

% Defining the parameters needed for image denoising

SMALL.solver(2).toolbox='SPAMS';
SMALL.solver(2).name='mexLasso';
SMALL.solver(2).param=struct(...
    'mode', 2, ...
     'lambda',lambda(i),...
    'L', maxatoms); 

%   Denoising the image - SMALL_denoise function is similar to SMALL_solve,
%   but backward compatible with KSVD definition of denoising
%   Pay attention that since implicit base dictionary is used, denoising
%   can be much faster then using explicit dictionary in KSVD example.

SMALL.solver(2)=SMALL_solve(SMALL.Problem, SMALL.solver(2));


% show results %

%SMALL_ImgDeNoiseResult(SMALL);

    time(1,i) = SMALL.solver(2).time;
    psnr(1,i) = SMALL.solver(2).reconstructed.psnr;
end%% show time and psnr %%
figure('Name', 'SPAMS LAMBDA TEST');

subplot(1,2,1); plot(lambda, time(1,:), 'ro-');
title('time vs lambda');
subplot(1,2,2); plot(lambda, psnr(1,:), 'b*-');
title('PSNR vs lambda');